<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:atom="http://www.w3.org/2005/Atom"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:content="http://purl.org/rss/1.0/modules/content/">
  <xsl:output method="html"
              version="5.0"
              encoding="UTF-8"
              indent="yes"
              doctype-system="about:legacy-compat" />
  <xsl:template match="/">
    <html lang="en">
      <head>
        <title><xsl:value-of select="/rss/channel/title" /> (Web Feed Preview)</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
        <meta name="author" lang="en" content="Matthew Graybosch"/>
        <meta name="ICBM" content="40.2732, -76.8867"/>
        <meta name="color-scheme" content="light dark"/>
        <meta name="usage-rights" content="Creative Commons BY-NC-SA 4.0 International"/>
        <meta name="robots" content="index, follow, noai, noimageai"/>
        <meta name="pinterest" content="nopin" description="Pinterest is just hotlinking as a service."/>
        <link rel="apple-touch-icon" sizes="180x180" href="./apple-touch-icon.png"/>
        <link rel="icon" type="image/png" sizes="32x32" href="./favicon-32x32.png"/>
        <link rel="icon" type="image/png" sizes="16x16" href="./favicon-16x16.png"/>
        <link rel="manifest" href="/site.webmanifest"/>
        <link rel="license" href="https://creativecommons.org/licenses/by-nc-sa/4.0/"/>
        <link rel="canonical" href="https://actualwebsite.org/rss.xml"/>
        <link rel="stylesheet" href="./assets/styles/page.css"/>
        <link rel="alternate" type="application/rss+xml" title="RSS feed" href="./rss.xml"/>
        <link rel="stylesheet" href="./assets/styles/page.css" />
      </head>
      <body>
        <header>
          <h1>
            <xsl:value-of select="/rss/channel/title" />
          </h1>
          <p>
            <xsl:value-of select="/rss/channel/description" />
          </p>
          <p>
            <a target="_blank"> <xsl:attribute name="href"> <xsl:value-of select="/rss/channel/link" /> </xsl:attribute> Visit the Website &#x2192;</a>
          </p>
        </header>
        <hr/>
        <main id="content">
          <section>
            <h2>
              <img class="undecorated"
                   src="./assets/images/rss-icon.svg"
                   width="24"
                   height="24"
                   alt="RSS vector icon" /> Web Feed Preview
            </h2>
            <p>
              <strong>This is a web feed,</strong> also known as a RSS feed.
              <strong>Subscribe</strong> by copying the URL from the address bar into your newsreader.
            </p>
            <p>
              Visit <a href="https://aboutfeeds.com">About Feeds</a> to get started with newsreaders and subscribing.
              It’s free and anonymous.
              No email needed!
            </p>
          </section>
          <hr/>
          <xsl:for-each select="/rss/channel/item">
            <article class="h-entry">
              <h2>
                <a target="_blank">
                  <xsl:attribute name="href">
                    <xsl:value-of select="link" />
                  </xsl:attribute>
                  <xsl:value-of select="title" />
                </a>
              </h2>
              <p><i><xsl:value-of select="substring(pubDate, 0, 17)" /></i></p>
              <xsl:value-of select="description"/>
            </article>
          </xsl:for-each>
        </main>
        <hr/>
        <footer>
          <p>
            This feed is provided free of charge.
            Thanks for visiting.
          </p>
        </footer>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
